gFileName = "backgrounds/int_tut";
gFilesCount = 5;
gCurrentFile = 2;

HelpFont = {
  standardFont,
  18,
  BlackColor
};

HelpTitleFont = {
  standardFont,
  22,
  BlackColor
};


function SetScreen(screen)
    if(screen<1 or screen>gFilesCount)then
		PopModal("help");
		return;
    else
        gCurrentFile = screen;
        if(gCurrentFile==1)then
			EnableWindow ("first_button", false);
        else
            SetLabel("first_button",GetString("prev"));
			EnableWindow ("first_button", true);			
        end;
        
        if(gCurrentFile==gFilesCount)then
			EnableWindow ("second_button", false);						
        else
            SetLabel("second_button",GetString("next"));
			EnableWindow ("second_button", true);						
        end;
        
        SetBitmap("tutorial_image",gFileName..gCurrentFile);
    end
    for i =1, gFilesCount do
        local flag=false;
        if i == screen then 
            flag = true;
        end
        EnableWindow ("page_"..i, flag);		
    end
end

MakeDialog
{
    name="help",
    
    ParamTimer
    {
        param = "HelpScreenTime";
    };
    
    Bitmap
    {
        name="tutorial_image",
        image=gFileName..gCurrentFile,
        x=0,
        y=0,
		w = 800,
		h = 600,
        Button
        {
            x=50,
            y=520,
			w=100,
			h = 44,
            font = StandardButtonFont,
            graphics = TutorialButton,
            name="first_button",
            sound=kDefaultButtonSound,                        
            label="prev",
            type = kPush,
            command=
                function()
                    SetScreen(gCurrentFile-1);
                end
        },
		
		
        Button
        {
            x=340,
            y=520,
			w=100,
			h = 44,
            font = StandardButtonFont,
            graphics = TutorialButton,
            sound=kDefaultButtonSound,                        
            name="skip_button",
            label="close",
            type = kPush,
            command=
                function()
                    SetScreen(999999);
                end
        },
		
		
		
        Button
        {
            x=650,
            y=520,
			w=100,
			h = 44,			
            font = StandardButtonFont,
            graphics = TutorialButton,
            sound=kDefaultButtonSound,                        
            name="second_button",
            label="next",
            type = kPush,
            command=
                function()
                    SetScreen(gCurrentFile+1);
                end
        },
        
        
        Text {
            name = "help_title",
            font = {
                standardFont,
                40,
                WhiteColor
            },
            x = 320,
            y = 9,
            w = 150,
            h = 50,
            label="help",
            flags = kHAlignCenter + kVAlignCenter,
        },

        Window
        {
            name = "page_1";
            w = 800,
            h = 600,
            
            Text {
                name = "help_1_caption",
                font = HelpTitleFont,
x = 318,
 y = 53,
w = 150,
 h = 38,
                label="help_1_caption",
                flags = kHAlignCenter + kVAlignCenter,
            },
            
            Text {
                name = "help_1_1",
                font = HelpFont,
x = 105,
 y = 163,
w = 150,
 h = 53,
                label="help_1_1",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_1_2",
                font = HelpFont,
x = 327,
 y = 156,
w = 155,
 h = 63,
                label="help_1_2",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_1_3",
                font = HelpFont,
x = 559,
 y = 159,
w = 150,
 h = 68,
                label="help_1_3",
                flags = kHAlignCenter + kVAlignCenter,
            },            
            Text {
                name = "help_1_4",
                font = HelpFont,
x = 113,
 y = 330,
w = 600,
 h = 73,
                label="help_1_4",
                flags = kHAlignCenter + kVAlignCenter,
            }, 
            Text {
                name = "help_1_5",
                font = HelpFont,
x = 128,
 y = 356,
w = 235,
 h = 78,
                label="help_1_5",
                flags = kHAlignCenter + kVAlignCenter,
            }, 
            Text {
                name = "help_1_6",
                font = HelpFont,
x = 423,
 y = 371,
w = 110,
 h = 38,
                label="help_1_6",
                flags = kHAlignCenter + kVAlignCenter,
            },             
            
        },
        
        Window
        {
            name = "page_2";
            w = 800,
            h = 600,
            Text {
                name = "help_2_caption",
                font = HelpTitleFont,
x = 239,
 y = 60,
w = 310,
 h = 28,
                label="help_2_caption",
                flags = kHAlignCenter + kVAlignCenter,
            },
            
            Text {
                name = "help_2_1",
                font = HelpFont,
x = 68,
 y = 67,
w = 650,
 h = 103,
                label="help_2_1",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_2_2",
                font = HelpFont,
x = 99,
 y = 165,
w = 155,
 h = 63,
                label="help_2_2",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_2_3",
                font = HelpFont,
x = 327,
 y = 159,
w = 150,
 h = 68,
                label="help_2_3",
                flags = kHAlignCenter + kVAlignCenter,
            },            
            Text {
                name = "help_2_4",
                font = HelpFont,
x = 532,
 y = 140,
w = 185,
 h = 113,
                label="help_2_4",
                flags = kHAlignCenter + kVAlignCenter,
            }, 
            Text {
                name = "help_2_5",
                font = HelpFont,
x = 281,
 y = 357,
w = 235,
 h = 78,
                label="help_2_5",
                flags = kHAlignCenter + kVAlignCenter,
            }, 
         
        },
        
        Window
        {
            name = "page_3";
            w = 800,
            h = 600,
            Text {
                name = "help_3_caption",
                font = HelpTitleFont,
x = 320,
 y = 52,
w = 150,
 h = 38,
                label="help_3_caption",
                flags = kHAlignCenter + kVAlignCenter,
            },
            
            Text {
                name = "help_3_1",
                font = HelpFont,
x = 64,
 y = 41,
w = 650,
 h = 103,
                label="help_3_1",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_3_2",
                font = HelpFont,
x = 95,
 y = 135,
w = 155,
 h = 73,
                label="help_3_2",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_3_3",
                font = HelpFont,
x = 308,
 y = 100,
w = 185,
 h = 118,
                label="help_3_3",
                flags = kHAlignCenter + kVAlignCenter,
            },            
            Text {
                name = "help_3_4",
                font = HelpFont,
x = 536,
 y = 84,
w = 175,
 h = 143,
                label="help_3_4",
                flags = kHAlignCenter + kVAlignCenter,
            }, 
            Text {
                name = "help_3_5",
                font = HelpFont,
x = 293,
 y = 338,
w = 340,
 h = 78,
                label="help_3_5",
                flags = kHAlignCenter + kVAlignCenter,
            }, 

        },
        
        Window
        {
            name = "page_4";
            w = 800,
            h = 600,
            Text {
                name = "help_4_caption",
                font = HelpTitleFont,
x = 317,
 y = 65,
w = 150,
 h = 38,
                label="help_4_caption",
                flags = kHAlignCenter + kVAlignCenter,
            },
            
            Text {
                name = "help_4_1",
                font = HelpFont,
x = 92,
 y = 145,
w = 190,
 h = 68,
                label="help_4_1",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_4_2",
                font = HelpFont,
x = 336,
 y = 139,
w = 155,
 h = 63,
                label="help_4_2",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_4_3",
                font = HelpFont,
x = 544,
 y = 24,
w = 165,
 h = 293,
                label="help_4_3",
                flags = kHAlignCenter + kVAlignCenter,
            },            
            Text {
                name = "help_4_4",
                font = HelpFont,
x = 90,
 y = 343,
w = 171,
 h = 73,
                label="help_4_4",
                flags = kHAlignCenter + kVAlignCenter,
            }, 
            Text {
                name = "help_4_5",
                font = HelpFont,
x = 274,
 y = 338,
w = 235,
 h = 78,
                label="help_4_5",
                flags = kHAlignCenter + kVAlignCenter,
            }, 
            Text {
                name = "help_4_6",
                font = HelpFont,
x = 321,
 y = 378,
w = 100,
 h = 138,
                label="help_4_6",
                flags = kHAlignCenter + kVAlignCenter,
            },             
            Text {
                name = "help_4_7",
                font = HelpFont,
x = 525,
 y = 343,
w = 190,
 h = 88,
                label="help_4_7",
                flags = kHAlignCenter + kVAlignCenter,
            },         
            
        },
        
        Window
        {
            name = "page_5";
            w = 800,
            h = 600,
            Text {
                name = "help_5_caption",
                font = HelpTitleFont,
x = 318,
 y = 64,
w = 150,
 h = 38,
                label="help_5_caption",
                flags = kHAlignCenter + kVAlignCenter,
            },
            
            Text {
                name = "help_5_1",
                font = HelpFont,
x = 87,
 y = 48,
w = 250,
 h = 238,
                label="help_5_1",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_5_2",
                font = HelpFont,
x = 428,
 y = 128,
w = 250,
 h = 63,
                label="help_5_2",
                flags = kHAlignCenter + kVAlignCenter,
            },
            Text {
                name = "help_5_3",
                font = HelpFont,
x = 89,
 y = 345,
w = 245,
 h = 68,
                label="help_5_3",
                flags = kHAlignCenter + kVAlignCenter,
            },            
            Text {
                name = "help_5_4",
                font = HelpFont,
x = 452,
 y = 332,
w = 230,
 h = 113,
                label="help_5_4",
                flags = kHAlignCenter + kVAlignCenter,
            }, 

          
            
        },        
        
        
        
    }   
}
SetUnderlineDistance("help_4_6",-3);
SetScreen(1);
